<?php
class Migrations_Migration373 Extends Shopware\Components\Migrations\AbstractMigration
{
    public function up($modus)
    {
        /**
         * Migrate s_emarketing_partner
         */
        $sql = <<<'EOD'
        ALTER TABLE `s_emarketing_partner` CHANGE `street` `street` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL;
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        UPDATE s_emarketing_partner SET street = CONCAT(street, ' ', streetnumber);
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        ALTER TABLE `s_emarketing_partner` DROP `streetnumber`;
EOD;
        $this->addSql($sql);



        /**
         * Migrate s_campaigns_maildata
         */
        $sql = <<<'EOD'
        UPDATE s_campaigns_maildata SET street = CONCAT(street, ' ', streetnumber);
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        ALTER TABLE `s_campaigns_maildata` DROP `streetnumber`;
EOD;
        $this->addSql($sql);



        /**
         * Migrate other data (emails, translations, etc)
         */
        $sql = <<<'EOD'

        UPDATE s_core_config_mails SET
            context = 'a:29:{s:5:"sShop";s:7:"Deutsch";s:8:"sShopURL";s:27:"http://trunk.qa.shopware.in";s:7:"sConfig";a:0:{}s:5:"sMAIL";s:14:"xy@example.org";s:7:"country";s:1:"2";s:13:"customer_type";s:7:"private";s:10:"salutation";s:4:"Herr";s:9:"firstname";s:8:"Banjimen";s:8:"lastname";s:6:"Ercmer";s:5:"phone";s:8:"55555555";s:3:"fax";N;s:5:"text1";N;s:5:"text2";N;s:5:"text3";N;s:5:"text4";N;s:5:"text5";N;s:5:"text6";N;s:11:"sValidation";N;s:9:"birthyear";s:0:"";s:10:"birthmonth";s:0:"";s:8:"birthday";s:0:"";s:11:"dpacheckbox";N;s:7:"company";s:0:"";s:6:"street";s:17:"Musterstreaße 55";s:7:"zipcode";s:5:"55555";s:4:"city";s:11:"Musterhsuen";s:10:"department";s:0:"";s:15:"shippingAddress";N;s:7:"stateID";N;}'
        WHERE
            context LIKE 'a:30:{s:5:"sShop";s:7:"Deutsch";s:8:"sShopURL";s:27:"http://trunk.qa.shopware.in";s:7:"sConfig";a:0:{}s:5:"sMAIL";s:14:"xy@example.org";s:7:"country";s:1:"2";s:13:"customer_type";s:7:"private";s:10:"salutation";s:4:"Herr";s:9:"firstname";s:8:"Banjimen";s:8:"lastname";s:6:"Ercmer";s:5:"phone";s:8:"55555555";s:3:"fax";N;s:5:"text1";N;s:5:"text2";N;s:5:"text3";N;s:5:"text4";N;s:5:"text5";N;s:5:"text6";N;s:11:"sValidation";N;s:9:"birthyear";s:0:"";s:10:"birthmonth";s:0:"";s:8:"birthday";s:0:"";s:11:"dpacheckbox";N;s:7:"company";s:0:"";s:6:"street";s:14:"Musterstreaße";s:12:"streetnumber";s:2:"55";s:7:"zipcode";s:5:"55555";s:4:"city";s:11:"Musterhsuen";s:10:"department";s:0:"";s:15:"shippingAddress";N;s:7:"stateID";N;}';
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        UPDATE s_core_config_mails SET
            context = 'a:18:{s:13:"sOrderDetails";a:5:{i:0;a:54:{s:2:"id";s:3:"122";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:27:"Versandkostenfreier Artikel";s:9:"articleID";s:3:"220";s:11:"ordernumber";s:7:"SW10001";s:12:"shippingfree";s:1:"1";s:8:"quantity";s:1:"1";s:5:"price";s:5:"35,99";s:8:"netprice";s:15:"30.243697478992";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 11:17:55";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"0";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"220";s:16:"articleDetailsID";s:3:"773";s:11:"ordernumber";s:7:"SW10001";s:5:"datum";s:10:"2012-08-29";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:289:"Sie haben die Möglichkeit, Artikel versandkostenfrei zu versenden. Auch wenn Sie Versandkosten konfiguriert haben, greifen diese nicht, sobald  in den Artikelstammdaten das Feld "Versandkostenfrei" selektiert ist.\n\nLegen Sie diesen Artikel in den Warenkorb und sehen sich das Ergebnis an.";s:16:"description_long";s:289:"Sie haben die Möglichkeit, Artikel versandkostenfrei zu versenden. Auch wenn Sie Versandkosten konfiguriert haben, greifen diese nicht, sobald  in den Artikelstammdaten das Feld "Versandkostenfrei" selektiert ist.\n\nLegen Sie diesen Artikel in den Warenkorb und sehen sich das Ergebnis an.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:27:"Versandkostenfreier Artikel";s:5:"taxID";s:1:"1";s:5:"price";s:5:"35,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"0";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"1";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:109:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c.jpg";i:0;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_30x30.jpg";i:1;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_57x57.jpg";i:2;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_105x105.jpg";i:3;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_140x140.jpg";i:4;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_285x255.jpg";i:5;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:555;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10001";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=220";s:10:"properties";b:0;}s:6:"amount";s:5:"35,99";s:9:"amountnet";s:5:"30,24";s:12:"priceNumeric";s:5:"35.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:109:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c.jpg";i:0;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_30x30.jpg";i:1;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_57x57.jpg";i:2;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_105x105.jpg";i:3;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_140x140.jpg";i:4;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_285x255.jpg";i:5;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:555;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=220";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=122";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10001";s:3:"tax";s:4:"5,75";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:54:{s:2:"id";s:3:"168";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:27:"Aufschlag bei Zahlungsarten";s:9:"articleID";s:3:"227";s:11:"ordernumber";s:10:"SW10002841";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:5:"35,99";s:8:"netprice";s:15:"30.243697478992";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 14:51:43";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"0";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"227";s:16:"articleDetailsID";s:3:"782";s:11:"ordernumber";s:10:"SW10002841";s:5:"datum";s:10:"2012-08-29";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:414:"In Shopware können Sie bei gewünchten Zahlungsarten Aufschläge definieren.\nSo ist bei diesem Beispiel ein Aufschlag von 5€ auf die Zahlungsart Rechnung definiert worden.\nMelden Sie sich als Shopkunden max.mustermann@mail.com (Passwort: shopware) an, gehen in den "Mein Konto" Bereich und wechseln auf die Zahlungsart "Rechnung".\nBei jeder Bestellung wird Ihnen nun der Zuschlag für die Zahlungsart berechnet.";s:16:"description_long";s:414:"In Shopware können Sie bei gewünchten Zahlungsarten Aufschläge definieren.\nSo ist bei diesem Beispiel ein Aufschlag von 5€ auf die Zahlungsart Rechnung definiert worden.\nMelden Sie sich als Shopkunden max.mustermann@mail.com (Passwort: shopware) an, gehen in den "Mein Konto" Bereich und wechseln auf die Zahlungsart "Rechnung".\nBei jeder Bestellung wird Ihnen nun der Zuschlag für die Zahlungsart berechnet.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:27:"Aufschlag bei Zahlungsarten";s:5:"taxID";s:1:"1";s:5:"price";s:5:"35,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"0";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"1";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:93:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Kampfsport-Guertel503e238936d35.jpg";i:0;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_30x30.jpg";i:1;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_57x57.jpg";i:2;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_105x105.jpg";i:3;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_140x140.jpg";i:4;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_285x255.jpg";i:5;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:561;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:45:"shopware.php?sViewport=basket&sAdd=SW10002841";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=227";s:10:"properties";b:0;}s:6:"amount";s:5:"35,99";s:9:"amountnet";s:5:"30,24";s:12:"priceNumeric";s:5:"35.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:93:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Kampfsport-Guertel503e238936d35.jpg";i:0;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_30x30.jpg";i:1;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_57x57.jpg";i:2;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_105x105.jpg";i:3;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_140x140.jpg";i:4;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_285x255.jpg";i:5;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:561;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=227";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=168";s:8:"linkNote";s:43:"shopware.php?sViewport=note&sAdd=SW10002841";s:3:"tax";s:4:"5,75";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:54:{s:2:"id";s:3:"642";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:15:"Express Versand";s:9:"articleID";s:3:"219";s:11:"ordernumber";s:7:"SW10185";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:5:"54,90";s:8:"netprice";s:15:"46.134453781513";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 18:01:35";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"5";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:1:"5";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"1";s:12:"shippingtime";s:0:"";s:11:"releasedate";s:0:"";s:12:"sReleaseDate";s:0:"";s:8:"stockmin";s:1:"1";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"219";s:16:"articleDetailsID";s:3:"772";s:11:"ordernumber";s:7:"SW10185";s:5:"datum";s:10:"2012-06-12";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:142:"In Shopware können Sie auch einen Expressversand anbieten. Hier wird dem Shopkunden  entsprechend höhere Versandkosten in Rechnung gestellt.";s:16:"description_long";s:142:"In Shopware können Sie auch einen Expressversand anbieten. Hier wird dem Shopkunden  entsprechend höhere Versandkosten in Rechnung gestellt.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:15:"Express Versand";s:5:"taxID";s:1:"1";s:5:"price";s:5:"54,90";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:37:"3x 250 ml Weincuvéeund feinstem Zimt";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"5";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"1";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"0";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:99:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b.jpg";i:0;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_30x30.jpg";i:1;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_57x57.jpg";i:2;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_105x105.jpg";i:3;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_140x140.jpg";i:4;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_285x255.jpg";i:5;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:554;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10185";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=219";s:10:"properties";b:0;}s:6:"amount";s:5:"54,90";s:9:"amountnet";s:5:"46,13";s:12:"priceNumeric";s:4:"54.9";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:99:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b.jpg";i:0;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_30x30.jpg";i:1;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_57x57.jpg";i:2;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_105x105.jpg";i:3;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_140x140.jpg";i:4;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_285x255.jpg";i:5;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:554;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=219";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=642";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10185";s:3:"tax";s:4:"8,77";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:55:{s:2:"id";s:3:"653";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:20:"ESD Download Artikel";s:9:"articleID";s:3:"197";s:11:"ordernumber";s:7:"SW10196";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"2";s:5:"price";s:5:"34,99";s:8:"netprice";s:15:"29.403361344538";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-31 08:37:39";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"3";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"1";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"197";s:16:"articleDetailsID";s:3:"437";s:11:"ordernumber";s:7:"SW10196";s:5:"datum";s:10:"2012-07-16";s:5:"sales";s:1:"4";s:9:"highlight";s:1:"0";s:11:"description";s:318:"Electronic Software Distribution (ESD) hilft Ihnen bei dem Vertrieb von reinen Software Produkten. Diese Produkte werden online bestellt, bezahlt und zum Download bereit gestellt. Neben Software können auch andere digitale Artikel, wie E-Books, Musik (mp3), Videos, Computerspiele etc. auf ESD-Basis angeboten werden.";s:16:"description_long";s:318:"Electronic Software Distribution (ESD) hilft Ihnen bei dem Vertrieb von reinen Software Produkten. Diese Produkte werden online bestellt, bezahlt und zum Download bereit gestellt. Neben Software können auch andere digitale Artikel, wie E-Books, Musik (mp3), Videos, Computerspiele etc. auf ESD-Basis angeboten werden.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:20:"ESD Download Artikel";s:5:"taxID";s:1:"1";s:5:"price";s:5:"34,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"3";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"1";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"0";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:81:"http://qa.de.server678-han.de-nserver.de/media/image/Buecher-ESD503f5a25e6a12.jpg";i:0;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_30x30.jpg";i:1;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_57x57.jpg";i:2;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_105x105.jpg";i:3;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_140x140.jpg";i:4;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_285x255.jpg";i:5;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:604;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10196";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=197";s:10:"properties";b:0;}s:6:"amount";s:5:"69,98";s:9:"amountnet";s:5:"58,81";s:12:"priceNumeric";s:5:"34.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:81:"http://qa.de.server678-han.de-nserver.de/media/image/Buecher-ESD503f5a25e6a12.jpg";i:0;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_30x30.jpg";i:1;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_57x57.jpg";i:2;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_105x105.jpg";i:3;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_140x140.jpg";i:4;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_285x255.jpg";i:5;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:604;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=197";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=653";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10196";s:3:"tax";s:5:"11,17";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}s:7:"serials";a:2:{i:0;s:11:"12345679890";i:1;s:11:"23456798901";}}i:4;a:52:{s:2:"id";s:3:"664";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"0";s:11:"articlename";s:25:"Zuschlag für Zahlungsart";s:9:"articleID";s:1:"0";s:11:"ordernumber";s:19:"sw-payment-absolute";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:4:"5,00";s:8:"netprice";s:3:"4.2";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-31 08:51:25";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:0:"";s:9:"useragent";s:0:"";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";N;s:11:"minpurchase";i:1;s:5:"taxID";N;s:7:"instock";N;s:14:"suppliernumber";N;s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";N;s:12:"shippingtime";N;s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";N;s:8:"itemUnit";N;s:8:"ob_attr1";N;s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:0;s:3:"esd";s:1:"0";s:6:"amount";s:4:"5,00";s:9:"amountnet";s:4:"4,20";s:12:"priceNumeric";s:1:"5";s:11:"linkDetails";s:40:"shopware.php?sViewport=detail&sArticle=0";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=664";s:8:"linkNote";s:52:"shopware.php?sViewport=note&sAdd=sw-payment-absolute";s:3:"tax";s:4:"0,80";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:14:"billingaddress";a:17:{s:2:"id";s:1:"1";s:6:"userID";s:1:"1";s:7:"company";s:11:"shopware AG";s:10:"department";s:0:"";s:10:"salutation";s:2:"mr";s:14:"customernumber";s:5:"20002";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:6:"street";s:20:"Mustermannstraße 92";s:7:"zipcode";s:5:"48624";s:4:"city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:3:"fax";s:0:"";s:9:"countryID";s:1:"2";s:7:"stateID";s:1:"3";s:5:"ustid";s:0:"";s:8:"birthday";s:10:"1978-08-16";}s:15:"shippingaddress";a:12:{s:2:"id";s:1:"2";s:6:"userID";s:1:"1";s:7:"company";s:11:"shopware AG";s:10:"department";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:6:"street";s:20:"Mustermannstraße 92";s:7:"zipcode";s:5:"48624";s:4:"city";s:12:"Schöppingen";s:9:"countryID";s:1:"2";s:7:"stateID";s:1:"0";}s:10:"additional";a:8:{s:7:"country";a:15:{s:2:"id";s:1:"2";s:11:"countryname";s:11:"Deutschland";s:10:"countryiso";s:2:"DE";s:6:"areaID";s:1:"1";s:9:"countryen";s:7:"GERMANY";s:8:"position";s:1:"1";s:6:"notice";s:0:"";s:12:"shippingfree";s:1:"0";s:7:"taxfree";s:1:"0";s:13:"taxfree_ustid";s:1:"0";s:21:"taxfree_ustid_checked";s:1:"0";s:6:"active";s:1:"1";s:4:"iso3";s:3:"DEU";s:29:"display_state_in_registration";s:1:"0";s:27:"force_state_in_registration";s:1:"0";}s:5:"state";a:6:{s:2:"id";s:1:"3";s:9:"countryID";s:1:"2";s:4:"name";s:19:"Nordrhein-Westfalen";s:9:"shortcode";s:2:"NW";s:8:"position";s:1:"0";s:6:"active";s:1:"1";}s:4:"user";a:22:{s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:5:"email";s:23:"max.mustermann@mail.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"4";s:10:"firstlogin";s:10:"2012-08-29";s:9:"lastlogin";s:19:"2012-08-31 08:51:25";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:10:"newsletter";i:0;s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"4";s:8:"language";s:0:"";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;}s:15:"countryShipping";a:16:{s:2:"id";s:1:"2";s:11:"countryname";s:11:"Deutschland";s:10:"countryiso";s:2:"DE";s:6:"areaID";s:1:"1";s:9:"countryen";s:7:"GERMANY";s:8:"position";s:1:"1";s:6:"notice";s:0:"";s:12:"shippingfree";s:1:"0";s:7:"taxfree";s:1:"0";s:13:"taxfree_ustid";s:1:"0";s:21:"taxfree_ustid_checked";s:1:"0";s:6:"active";s:1:"1";s:4:"iso3";s:3:"DEU";s:29:"display_state_in_registration";s:1:"0";s:27:"force_state_in_registration";s:1:"0";s:11:"countryarea";s:11:"deutschland";}s:13:"stateShipping";a:0:{}s:7:"payment";a:19:{s:2:"id";s:1:"4";s:4:"name";s:7:"invoice";s:11:"description";s:8:"Rechnung";s:8:"template";s:11:"invoice.tpl";s:5:"class";s:11:"invoice.php";s:5:"table";s:0:"";s:4:"hide";s:1:"0";s:21:"additionaldescription";s:210:"Sie zahlen einfach und bequem auf Rechnung. Shopware bietet z.B. auch die Möglichkeit, Rechnung automatisiert erst ab der 2. Bestellung für Kunden zur Verfügung zu stellen, um Zahlungsausfälle zu vermeiden.";s:13:"debit_percent";s:1:"0";s:9:"surcharge";s:1:"5";s:15:"surchargestring";s:0:"";s:8:"position";s:1:"3";s:6:"active";s:1:"1";s:9:"esdactive";s:1:"1";s:11:"embediframe";s:0:"";s:12:"hideprospect";s:1:"0";s:6:"action";s:0:"";s:8:"pluginID";N;s:6:"source";N;}s:10:"charge_vat";b:1;s:8:"show_net";b:1;}s:14:"sShippingCosts";s:5:"0 EUR";s:7:"sAmount";s:10:"201,86 EUR";s:10:"sAmountNet";s:10:"169,63 EUR";s:12:"sOrderNumber";i:20002;s:9:"sOrderDay";s:10:"31.08.2012";s:10:"sOrderTime";s:5:"08:51";s:8:"sComment";s:0:"";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}s:9:"sCurrency";s:3:"EUR";s:9:"sLanguage";s:1:"1";s:8:"sSubShop";s:1:"1";s:4:"sEsd";b:1;s:4:"sNet";b:0;s:9:"sDispatch";a:10:{s:2:"id";s:1:"9";s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";s:11:"calculation";s:1:"1";s:11:"status_link";s:0:"";s:21:"surcharge_calculation";s:1:"3";s:17:"bind_shippingfree";s:1:"0";s:12:"shippingfree";N;s:15:"tax_calculation";s:1:"0";s:21:"tax_calculation_value";N;}}'
        WHERE
            context LIKE 'a:18:{s:13:"sOrderDetails";a:5:{i:0;a:54:{s:2:"id";s:3:"122";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:27:"Versandkostenfreier Artikel";s:9:"articleID";s:3:"220";s:11:"ordernumber";s:7:"SW10001";s:12:"shippingfree";s:1:"1";s:8:"quantity";s:1:"1";s:5:"price";s:5:"35,99";s:8:"netprice";s:15:"30.243697478992";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 11:17:55";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"0";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"220";s:16:"articleDetailsID";s:3:"773";s:11:"ordernumber";s:7:"SW10001";s:5:"datum";s:10:"2012-08-29";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:289:"Sie haben die Möglichkeit, Artikel versandkostenfrei zu versenden. Auch wenn Sie Versandkosten konfiguriert haben, greifen diese nicht, sobald  in den Artikelstammdaten das Feld "Versandkostenfrei" selektiert ist.\n\nLegen Sie diesen Artikel in den Warenkorb und sehen sich das Ergebnis an.";s:16:"description_long";s:289:"Sie haben die Möglichkeit, Artikel versandkostenfrei zu versenden. Auch wenn Sie Versandkosten konfiguriert haben, greifen diese nicht, sobald  in den Artikelstammdaten das Feld "Versandkostenfrei" selektiert ist.\n\nLegen Sie diesen Artikel in den Warenkorb und sehen sich das Ergebnis an.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:27:"Versandkostenfreier Artikel";s:5:"taxID";s:1:"1";s:5:"price";s:5:"35,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"0";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"1";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:109:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c.jpg";i:0;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_30x30.jpg";i:1;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_57x57.jpg";i:2;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_105x105.jpg";i:3;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_140x140.jpg";i:4;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_285x255.jpg";i:5;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:555;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10001";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=220";s:10:"properties";b:0;}s:6:"amount";s:5:"35,99";s:9:"amountnet";s:5:"30,24";s:12:"priceNumeric";s:5:"35.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:109:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c.jpg";i:0;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_30x30.jpg";i:1;s:125:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_57x57.jpg";i:2;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_105x105.jpg";i:3;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_140x140.jpg";i:4;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_285x255.jpg";i:5;s:127:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Fussschuetzer-grip-leather-schwarz503e21d45c10c_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:555;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=220";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=122";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10001";s:3:"tax";s:4:"5,75";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:1;a:54:{s:2:"id";s:3:"168";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:27:"Aufschlag bei Zahlungsarten";s:9:"articleID";s:3:"227";s:11:"ordernumber";s:10:"SW10002841";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:5:"35,99";s:8:"netprice";s:15:"30.243697478992";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 14:51:43";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"0";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"227";s:16:"articleDetailsID";s:3:"782";s:11:"ordernumber";s:10:"SW10002841";s:5:"datum";s:10:"2012-08-29";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:414:"In Shopware können Sie bei gewünchten Zahlungsarten Aufschläge definieren.\nSo ist bei diesem Beispiel ein Aufschlag von 5€ auf die Zahlungsart Rechnung definiert worden.\nMelden Sie sich als Shopkunden max.mustermann@mail.com (Passwort: shopware) an, gehen in den "Mein Konto" Bereich und wechseln auf die Zahlungsart "Rechnung".\nBei jeder Bestellung wird Ihnen nun der Zuschlag für die Zahlungsart berechnet.";s:16:"description_long";s:414:"In Shopware können Sie bei gewünchten Zahlungsarten Aufschläge definieren.\nSo ist bei diesem Beispiel ein Aufschlag von 5€ auf die Zahlungsart Rechnung definiert worden.\nMelden Sie sich als Shopkunden max.mustermann@mail.com (Passwort: shopware) an, gehen in den "Mein Konto" Bereich und wechseln auf die Zahlungsart "Rechnung".\nBei jeder Bestellung wird Ihnen nun der Zuschlag für die Zahlungsart berechnet.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:27:"Aufschlag bei Zahlungsarten";s:5:"taxID";s:1:"1";s:5:"price";s:5:"35,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"0";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"1";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:93:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Kampfsport-Guertel503e238936d35.jpg";i:0;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_30x30.jpg";i:1;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_57x57.jpg";i:2;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_105x105.jpg";i:3;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_140x140.jpg";i:4;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_285x255.jpg";i:5;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:561;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:45:"shopware.php?sViewport=basket&sAdd=SW10002841";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=227";s:10:"properties";b:0;}s:6:"amount";s:5:"35,99";s:9:"amountnet";s:5:"30,24";s:12:"priceNumeric";s:5:"35.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:93:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Kampfsport-Guertel503e238936d35.jpg";i:0;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_30x30.jpg";i:1;s:109:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_57x57.jpg";i:2;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_105x105.jpg";i:3;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_140x140.jpg";i:4;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_285x255.jpg";i:5;s:111:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Kampfsport-Guertel503e238936d35_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:561;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=227";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=168";s:8:"linkNote";s:43:"shopware.php?sViewport=note&sAdd=SW10002841";s:3:"tax";s:4:"5,75";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:2;a:54:{s:2:"id";s:3:"642";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:15:"Express Versand";s:9:"articleID";s:3:"219";s:11:"ordernumber";s:7:"SW10185";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:5:"54,90";s:8:"netprice";s:15:"46.134453781513";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-30 18:01:35";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"5";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:1:"5";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"1";s:12:"shippingtime";s:0:"";s:11:"releasedate";s:0:"";s:12:"sReleaseDate";s:0:"";s:8:"stockmin";s:1:"1";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"0";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"219";s:16:"articleDetailsID";s:3:"772";s:11:"ordernumber";s:7:"SW10185";s:5:"datum";s:10:"2012-06-12";s:5:"sales";s:1:"0";s:9:"highlight";s:1:"0";s:11:"description";s:142:"In Shopware können Sie auch einen Expressversand anbieten. Hier wird dem Shopkunden  entsprechend höhere Versandkosten in Rechnung gestellt.";s:16:"description_long";s:142:"In Shopware können Sie auch einen Expressversand anbieten. Hier wird dem Shopkunden  entsprechend höhere Versandkosten in Rechnung gestellt.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:15:"Express Versand";s:5:"taxID";s:1:"1";s:5:"price";s:5:"54,90";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:37:"3x 250 ml Weincuvéeund feinstem Zimt";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"5";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"1";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"0";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"0";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:99:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b.jpg";i:0;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_30x30.jpg";i:1;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_57x57.jpg";i:2;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_105x105.jpg";i:3;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_140x140.jpg";i:4;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_285x255.jpg";i:5;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:554;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10185";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=219";s:10:"properties";b:0;}s:6:"amount";s:5:"54,90";s:9:"amountnet";s:5:"46,13";s:12:"priceNumeric";s:4:"54.9";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:99:"http://qa.de.server678-han.de-nserver.de/media/image/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b.jpg";i:0;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_30x30.jpg";i:1;s:115:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_57x57.jpg";i:2;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_105x105.jpg";i:3;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_140x140.jpg";i:4;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_285x255.jpg";i:5;s:117:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Kwon-Chosun-Plus-Schuhe-weiss503e21265ab7b_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:554;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=219";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=642";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10185";s:3:"tax";s:4:"8,77";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}i:3;a:55:{s:2:"id";s:3:"653";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"1";s:11:"articlename";s:20:"ESD Download Artikel";s:9:"articleID";s:3:"197";s:11:"ordernumber";s:7:"SW10196";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"2";s:5:"price";s:5:"34,99";s:8:"netprice";s:15:"29.403361344538";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-31 08:37:39";s:5:"modus";s:1:"0";s:10:"esdarticle";s:1:"1";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:7:"account";s:9:"useragent";s:106:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";s:0:"";s:11:"minpurchase";i:1;s:5:"taxID";s:1:"1";s:7:"instock";s:1:"3";s:14:"suppliernumber";s:0:"";s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";s:1:"0";s:12:"shippingtime";s:0:"";s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";s:1:"0";s:8:"itemUnit";N;s:8:"ob_attr1";s:0:"";s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:1;s:3:"esd";s:1:"1";s:18:"additional_details";a:59:{s:9:"articleID";s:3:"197";s:16:"articleDetailsID";s:3:"437";s:11:"ordernumber";s:7:"SW10196";s:5:"datum";s:10:"2012-07-16";s:5:"sales";s:1:"4";s:9:"highlight";s:1:"0";s:11:"description";s:318:"Electronic Software Distribution (ESD) hilft Ihnen bei dem Vertrieb von reinen Software Produkten. Diese Produkte werden online bestellt, bezahlt und zum Download bereit gestellt. Neben Software können auch andere digitale Artikel, wie E-Books, Musik (mp3), Videos, Computerspiele etc. auf ESD-Basis angeboten werden.";s:16:"description_long";s:318:"Electronic Software Distribution (ESD) hilft Ihnen bei dem Vertrieb von reinen Software Produkten. Diese Produkte werden online bestellt, bezahlt und zum Download bereit gestellt. Neben Software können auch andere digitale Artikel, wie E-Books, Musik (mp3), Videos, Computerspiele etc. auf ESD-Basis angeboten werden.";s:12:"supplierName";s:7:"Example";s:11:"supplierImg";s:0:"";s:11:"articleName";s:20:"ESD Download Artikel";s:5:"taxID";s:1:"1";s:5:"price";s:5:"34,99";s:11:"pseudoprice";s:1:"0";s:3:"tax";s:5:"19.00";s:5:"attr1";s:0:"";s:5:"attr2";s:0:"";s:5:"attr3";s:0:"";s:5:"attr4";s:0:"";s:5:"attr5";s:0:"";s:5:"attr6";s:0:"";s:5:"attr7";s:0:"";s:5:"attr8";s:0:"";s:5:"attr9";s:0:"";s:6:"attr10";s:0:"";s:6:"attr11";s:0:"";s:6:"attr12";s:0:"";s:6:"attr13";s:0:"";s:6:"attr14";s:0:"";s:6:"attr15";s:0:"";s:6:"attr16";s:0:"";s:6:"attr17";N;s:6:"attr18";s:0:"";s:6:"attr19";s:0:"";s:6:"attr20";s:0:"";s:7:"instock";s:1:"3";s:6:"weight";s:5:"0.000";s:12:"shippingtime";N;s:10:"pricegroup";s:2:"EK";s:12:"pricegroupID";N;s:16:"pricegroupActive";s:1:"0";s:13:"filtergroupID";N;s:12:"purchaseunit";i:0;s:13:"referenceunit";i:0;s:6:"unitID";N;s:9:"laststock";s:1:"0";s:14:"additionaltext";s:0:"";s:13:"sConfigurator";s:1:"0";s:3:"esd";s:1:"1";s:13:"sVoteAverange";a:2:{s:8:"averange";i:0;s:5:"count";i:0;}s:10:"newArticle";s:1:"0";s:9:"topseller";s:1:"0";s:9:"sUpcoming";s:1:"0";s:12:"sReleasedate";s:0:"";s:15:"sVariantArticle";N;s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:81:"http://qa.de.server678-han.de-nserver.de/media/image/Buecher-ESD503f5a25e6a12.jpg";i:0;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_30x30.jpg";i:1;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_57x57.jpg";i:2;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_105x105.jpg";i:3;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_140x140.jpg";i:4;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_285x255.jpg";i:5;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:604;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:10:"linkBasket";s:42:"shopware.php?sViewport=basket&sAdd=SW10196";s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=197";s:10:"properties";b:0;}s:6:"amount";s:5:"69,98";s:9:"amountnet";s:5:"58,81";s:12:"priceNumeric";s:5:"34.99";s:5:"image";a:8:{s:3:"src";a:7:{s:8:"original";s:81:"http://qa.de.server678-han.de-nserver.de/media/image/Buecher-ESD503f5a25e6a12.jpg";i:0;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_30x30.jpg";i:1;s:97:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_57x57.jpg";i:2;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_105x105.jpg";i:3;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_140x140.jpg";i:4;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_285x255.jpg";i:5;s:99:"http://qa.de.server678-han.de-nserver.de/media/image/thumbnail/Buecher-ESD503f5a25e6a12_720x600.jpg";}s:3:"res";a:2:{s:8:"original";a:2:{s:5:"width";i:0;s:6:"height";i:0;}s:11:"description";s:0:"";}s:8:"position";i:1;s:9:"extension";s:3:"jpg";s:4:"main";i:1;s:2:"id";i:604;s:8:"parentId";N;s:9:"attribute";a:0:{}}s:11:"linkDetails";s:42:"shopware.php?sViewport=detail&sArticle=197";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=653";s:8:"linkNote";s:40:"shopware.php?sViewport=note&sAdd=SW10196";s:3:"tax";s:5:"11,17";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}s:7:"serials";a:2:{i:0;s:11:"12345679890";i:1;s:11:"23456798901";}}i:4;a:52:{s:2:"id";s:3:"664";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:6:"userID";s:1:"0";s:11:"articlename";s:25:"Zuschlag für Zahlungsart";s:9:"articleID";s:1:"0";s:11:"ordernumber";s:19:"sw-payment-absolute";s:12:"shippingfree";s:1:"0";s:8:"quantity";s:1:"1";s:5:"price";s:4:"5,00";s:8:"netprice";s:3:"4.2";s:8:"tax_rate";s:2:"19";s:5:"datum";s:19:"2012-08-31 08:51:25";s:5:"modus";s:1:"4";s:10:"esdarticle";s:1:"0";s:9:"partnerID";s:0:"";s:12:"lastviewport";s:0:"";s:9:"useragent";s:0:"";s:6:"config";s:0:"";s:14:"currencyFactor";s:1:"1";s:14:"liveshoppingID";s:1:"0";s:8:"bundleID";s:1:"0";s:23:"bundle_join_ordernumber";s:0:"";s:8:"packunit";N;s:11:"minpurchase";i:1;s:5:"taxID";N;s:7:"instock";N;s:14:"suppliernumber";N;s:11:"maxpurchase";s:3:"100";s:13:"purchasesteps";i:1;s:12:"purchaseunit";N;s:9:"laststock";N;s:12:"shippingtime";N;s:11:"releasedate";N;s:12:"sReleaseDate";N;s:8:"stockmin";N;s:8:"itemUnit";N;s:8:"ob_attr1";N;s:8:"ob_attr2";N;s:8:"ob_attr3";N;s:8:"ob_attr4";N;s:8:"ob_attr5";N;s:8:"ob_attr6";N;s:12:"shippinginfo";b:0;s:3:"esd";s:1:"0";s:6:"amount";s:4:"5,00";s:9:"amountnet";s:4:"4,20";s:12:"priceNumeric";s:1:"5";s:11:"linkDetails";s:40:"shopware.php?sViewport=detail&sArticle=0";s:10:"linkDelete";s:41:"shopware.php?sViewport=basket&sDelete=664";s:8:"linkNote";s:52:"shopware.php?sViewport=note&sAdd=sw-payment-absolute";s:3:"tax";s:4:"0,80";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}}}s:14:"billingaddress";a:18:{s:2:"id";s:1:"1";s:6:"userID";s:1:"1";s:7:"company";s:11:"shopware AG";s:10:"department";s:0:"";s:10:"salutation";s:2:"mr";s:14:"customernumber";s:5:"20002";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:6:"street";s:17:"Mustermannstraße";s:12:"streetnumber";s:2:"92";s:7:"zipcode";s:5:"48624";s:4:"city";s:12:"Schöppingen";s:5:"phone";s:0:"";s:3:"fax";s:0:"";s:9:"countryID";s:1:"2";s:7:"stateID";s:1:"3";s:5:"ustid";s:0:"";s:8:"birthday";s:10:"1978-08-16";}s:15:"shippingaddress";a:13:{s:2:"id";s:1:"2";s:6:"userID";s:1:"1";s:7:"company";s:11:"shopware AG";s:10:"department";s:0:"";s:10:"salutation";s:2:"mr";s:9:"firstname";s:3:"Max";s:8:"lastname";s:10:"Mustermann";s:6:"street";s:17:"Mustermannstraße";s:12:"streetnumber";s:2:"92";s:7:"zipcode";s:5:"48624";s:4:"city";s:12:"Schöppingen";s:9:"countryID";s:1:"2";s:7:"stateID";s:1:"0";}s:10:"additional";a:8:{s:7:"country";a:15:{s:2:"id";s:1:"2";s:11:"countryname";s:11:"Deutschland";s:10:"countryiso";s:2:"DE";s:6:"areaID";s:1:"1";s:9:"countryen";s:7:"GERMANY";s:8:"position";s:1:"1";s:6:"notice";s:0:"";s:12:"shippingfree";s:1:"0";s:7:"taxfree";s:1:"0";s:13:"taxfree_ustid";s:1:"0";s:21:"taxfree_ustid_checked";s:1:"0";s:6:"active";s:1:"1";s:4:"iso3";s:3:"DEU";s:29:"display_state_in_registration";s:1:"0";s:27:"force_state_in_registration";s:1:"0";}s:5:"state";a:6:{s:2:"id";s:1:"3";s:9:"countryID";s:1:"2";s:4:"name";s:19:"Nordrhein-Westfalen";s:9:"shortcode";s:2:"NW";s:8:"position";s:1:"0";s:6:"active";s:1:"1";}s:4:"user";a:22:{s:2:"id";s:1:"1";s:8:"password";s:32:"a256a310bc1e5db755fd392c524028a8";s:5:"email";s:23:"max.mustermann@mail.com";s:6:"active";s:1:"1";s:11:"accountmode";s:1:"0";s:15:"confirmationkey";s:0:"";s:9:"paymentID";s:1:"4";s:10:"firstlogin";s:10:"2012-08-29";s:9:"lastlogin";s:19:"2012-08-31 08:51:25";s:9:"sessionID";s:40:"66e9b10064a19b1fcf6eb9310c0753866c764836";s:10:"newsletter";i:0;s:10:"validation";s:1:"0";s:9:"affiliate";s:1:"0";s:13:"customergroup";s:2:"EK";s:13:"paymentpreset";s:1:"4";s:8:"language";s:0:"";s:9:"subshopID";s:1:"1";s:7:"referer";s:0:"";s:12:"pricegroupID";N;s:15:"internalcomment";s:0:"";s:12:"failedlogins";s:1:"0";s:11:"lockeduntil";N;}s:15:"countryShipping";a:16:{s:2:"id";s:1:"2";s:11:"countryname";s:11:"Deutschland";s:10:"countryiso";s:2:"DE";s:6:"areaID";s:1:"1";s:9:"countryen";s:7:"GERMANY";s:8:"position";s:1:"1";s:6:"notice";s:0:"";s:12:"shippingfree";s:1:"0";s:7:"taxfree";s:1:"0";s:13:"taxfree_ustid";s:1:"0";s:21:"taxfree_ustid_checked";s:1:"0";s:6:"active";s:1:"1";s:4:"iso3";s:3:"DEU";s:29:"display_state_in_registration";s:1:"0";s:27:"force_state_in_registration";s:1:"0";s:11:"countryarea";s:11:"deutschland";}s:13:"stateShipping";a:0:{}s:7:"payment";a:19:{s:2:"id";s:1:"4";s:4:"name";s:7:"invoice";s:11:"description";s:8:"Rechnung";s:8:"template";s:11:"invoice.tpl";s:5:"class";s:11:"invoice.php";s:5:"table";s:0:"";s:4:"hide";s:1:"0";s:21:"additionaldescription";s:210:"Sie zahlen einfach und bequem auf Rechnung. Shopware bietet z.B. auch die Möglichkeit, Rechnung automatisiert erst ab der 2. Bestellung für Kunden zur Verfügung zu stellen, um Zahlungsausfälle zu vermeiden.";s:13:"debit_percent";s:1:"0";s:9:"surcharge";s:1:"5";s:15:"surchargestring";s:0:"";s:8:"position";s:1:"3";s:6:"active";s:1:"1";s:9:"esdactive";s:1:"1";s:11:"embediframe";s:0:"";s:12:"hideprospect";s:1:"0";s:6:"action";s:0:"";s:8:"pluginID";N;s:6:"source";N;}s:10:"charge_vat";b:1;s:8:"show_net";b:1;}s:14:"sShippingCosts";s:5:"0 EUR";s:7:"sAmount";s:10:"201,86 EUR";s:10:"sAmountNet";s:10:"169,63 EUR";s:12:"sOrderNumber";i:20002;s:9:"sOrderDay";s:10:"31.08.2012";s:10:"sOrderTime";s:5:"08:51";s:8:"sComment";s:0:"";s:10:"attributes";a:6:{s:10:"attribute1";s:0:"";s:10:"attribute2";s:0:"";s:10:"attribute3";s:0:"";s:10:"attribute4";s:0:"";s:10:"attribute5";s:0:"";s:10:"attribute6";s:0:"";}s:9:"sCurrency";s:3:"EUR";s:9:"sLanguage";s:1:"1";s:8:"sSubShop";s:1:"1";s:4:"sEsd";b:1;s:4:"sNet";b:0;s:9:"sDispatch";a:10:{s:2:"id";s:1:"9";s:4:"name";s:16:"Standard Versand";s:11:"description";s:0:"";s:11:"calculation";s:1:"1";s:11:"status_link";s:0:"";s:21:"surcharge_calculation";s:1:"3";s:17:"bind_shippingfree";s:1:"0";s:12:"shippingfree";N;s:15:"tax_calculation";s:1:"0";s:21:"tax_calculation_value";N;}}';
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        UPDATE s_core_config_mails SET
            content = 'Hallo {$billingaddress.firstname} {$billingaddress.lastname},\n \nvielen Dank fuer Ihre Bestellung bei {config name=shopName} (Nummer: {$sOrderNumber}) am {$sOrderDay|date:"DATE_MEDIUM"} um {$sOrderTime|date:"TIME_SHORT"}.\nInformationen zu Ihrer Bestellung:\n \nPos. Art.Nr.              Menge         Preis        Summe\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nVersandkosten: {$sShippingCosts}\nGesamtkosten Netto: {$sAmountNet}\n{if !$sNet}\nGesamtkosten Brutto: {$sAmount}\n{/if}\n \nGewählte Zahlungsart: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nIhre Bankverbindung:\nKontonr: {$sPaymentTable.account}\nBLZ:{$sPaymentTable.bankcode}\nWir ziehen den Betrag in den nächsten Tagen von Ihrem Konto ein.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nUnsere Bankverbindung:\n{config name=bankAccount}\n{/if}\n \n{if $sComment}\nIhr Kommentar:\n{$sComment}\n{/if}\n \nRechnungsadresse:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nLieferadresse:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nIhre Umsatzsteuer-ID: {$billingaddress.ustid}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n{/if}\n \n \nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung. \n\nWir wünschen Ihnen noch einen schönen Tag.\n \n{config name=address}\n\n ',
            contentHTML = '<div style="font-family:arial; font-size:12px;">\n \n<p>Hallo {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nvielen Dank fuer Ihre Bestellung bei {config name=shopName} (Nummer: {$sOrderNumber}) am {$sOrderDay|date:"DATE_MEDIUM"} um {$sOrderTime|date:"TIME_SHORT"}.\n<br/>\n<br/>\n<strong>Informationen zu Ihrer Bestellung:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Artikel</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Versandkosten: {$sShippingCosts}<br/>\n    Gesamtkosten Netto: {$sAmountNet}<br/>\n    {if !$sNet}\n    Gesamtkosten Brutto: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Gewählte Zahlungsart:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Ihre Bankverbindung:<br/>\n    Kontonr: {$sPaymentTable.account}<br/>\n    BLZ:{$sPaymentTable.bankcode}<br/>\n    Wir ziehen den Betrag in den nächsten Tagen von Ihrem Konto ein.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Unsere Bankverbindung:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Gewählte Versandart:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Ihr Kommentar:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Rechnungsadresse:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Lieferadresse:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Ihre Umsatzsteuer-ID: {$billingaddress.ustid}<br/>\n    Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland<br/>\n    bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.<br/>\n    {/if}\n  <br/>\n  <br/>\n    Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung. Sie erreichen uns wie folgt: <br/>{config name=address}\n    <br/>\n    Mit freundlichen Grüßen,<br/>\n    Ihr Team von {config name=shopName}<br/>\n</p>\n</div>'
        WHERE
            content LIKE 'Hallo {$billingaddress.firstname} {$billingddress.lastname},\n \nvielen Dank fuer Ihre Bestellung bei {config name=shopName} (Nummer: {$sOrderNumber}) am {$sOrderDay|date:"DATE_MEDIUM"} um {$sOrderTime|date:"TIME_SHORT"}.\nInformationen zu Ihrer Bestellung:\n \nPos. Art.Nr.              Menge         Preis        Summe\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nVersandkosten: {$sShippingCosts}\nGesamtkosten Netto: {$sAmountNet}\n{if !$sNet}\nGesamtkosten Brutto: {$sAmount}\n{/if}\n \nGewählte Zahlungsart: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nIhre Bankverbindung:\nKontonr: {$sPaymentTable.account}\nBLZ:{$sPaymentTable.bankcode}\nWir ziehen den Betrag in den nächsten Tagen von Ihrem Konto ein.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nUnsere Bankverbindung:\n{config name=bankAccount}\n{/if}\n \n{if $sComment}\nIhr Kommentar:\n{$sComment}\n{/if}\n \nRechnungsadresse:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street} {$billingaddress.streetnumber}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nLieferadresse:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street} {$shippingaddress.streetnumber}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nIhre Umsatzsteuer-ID: {$billingaddress.ustid}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n{/if}\n \n \nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung. \n\nWir wünschen Ihnen noch einen schönen Tag.\n \n{config name=address}\n\n '
            AND contentHTML LIKE '<div style="font-family:arial; font-size:12px;">\n \n<p>Hallo {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nvielen Dank fuer Ihre Bestellung bei {config name=shopName} (Nummer: {$sOrderNumber}) am {$sOrderDay|date:"DATE_MEDIUM"} um {$sOrderTime|date:"TIME_SHORT"}.\n<br/>\n<br/>\n<strong>Informationen zu Ihrer Bestellung:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Artikel</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Versandkosten: {$sShippingCosts}<br/>\n    Gesamtkosten Netto: {$sAmountNet}<br/>\n    {if !$sNet}\n    Gesamtkosten Brutto: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Gewählte Zahlungsart:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Ihre Bankverbindung:<br/>\n    Kontonr: {$sPaymentTable.account}<br/>\n    BLZ:{$sPaymentTable.bankcode}<br/>\n    Wir ziehen den Betrag in den nächsten Tagen von Ihrem Konto ein.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Unsere Bankverbindung:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Gewählte Versandart:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Ihr Kommentar:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Rechnungsadresse:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street} {$billingaddress.streetnumber}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Lieferadresse:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street} {$shippingaddress.streetnumber}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Ihre Umsatzsteuer-ID: {$billingaddress.ustid}<br/>\n    Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland<br/>\n    bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.<br/>\n    {/if}\n  <br/>\n  <br/>\n    Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung. Sie erreichen uns wie folgt: <br/>{config name=address}\n    <br/>\n    Mit freundlichen Grüßen,<br/>\n    Ihr Team von {config name=shopName}<br/>\n</p>\n</div>'
            AND name LIKE 'sORDER';
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'

        UPDATE s_core_translations SET
            objectdata = 'a:3:{s:7:"subject";s:28:"Your order with the demoshop";s:7:"content";s:1739:"Hello {$billingaddress.firstname} {$billingaddress.lastname},\n \nThank you for your order at {config name=shopName} (Number: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\nInformation on your order:\n \nPos. Art.No.              Quantities         Price        Total\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nShipping costs: {$sShippingCosts}\nTotal net: {$sAmountNet}\n{if !$sNet}\nTotal gross: {$sAmount}\n{/if}\n \nSelected payment type: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nYour bank connection:\nAccount number: {$sPaymentTable.account}\nBIN:{$sPaymentTable.bankcode}\nWe will withdraw the money from your bank account within the next days.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nOur bank connection:\nAccount: ###\nBIN: ###\n{/if}\n \n{if $sComment}\nYour comment:\n{$sComment}\n{/if}\n \nBilling address:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nShipping address:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nYour VAT-ID: {$billingaddress.ustid}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n{/if}\n ";s:11:"contentHtml";s:3493:"<div style="font-family:arial; font-size:12px;">\n \n<p>Hello {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nThank you for your order with {config name=shopName} (Nummer: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\n<br/>\n<br/>\n<strong>Information on your order:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art.No.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Shipping costs:: {$sShippingCosts}<br/>\n    Total net: {$sAmountNet}<br/>\n    {if !$sNet}\n    Total gross: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Selected payment type:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Your bank connection:<br/>\n    Account number: {$sPaymentTable.account}<br/>\n    BIN:{$sPaymentTable.bankcode}<br/>\n    We will withdraw the money from your bank account within the next days.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Our bank connection:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Selected dispatch:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Your comment:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Billing address:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Shipping address:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Your VAT-ID: {$billingaddress.ustid}<br/>\n    In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n    {/if}\n  <br/>\n  <br/>\n\n    Your Team of {config name=shopName}<br/>\n</p>\n</div>";}'
        WHERE
            objectdata LIKE 'a:3:{s:7:"subject";s:28:"Your order with the demoshop";s:7:"content";s:1802:"Hello {$billingaddress.firstname} {$billingaddress.lastname},\n \nThank you for your order at {config name=shopName} (Number: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\nInformation on your order:\n \nPos. Art.No.              Quantities         Price        Total\n{foreach item=details key=position from=$sOrderDetails}\n{$position+1|fill:4} {$details.ordernumber|fill:20} {$details.quantity|fill:6} {$details.price|padding:8} EUR {$details.amount|padding:8} EUR\n{$details.articlename|wordwrap:49|indent:5}\n{/foreach}\n \nShipping costs: {$sShippingCosts}\nTotal net: {$sAmountNet}\n{if !$sNet}\nTotal gross: {$sAmount}\n{/if}\n \nSelected payment type: {$additional.payment.description}\n{$additional.payment.additionaldescription}\n{if $additional.payment.name == "debit"}\nYour bank connection:\nAccount number: {$sPaymentTable.account}\nBIN:{$sPaymentTable.bankcode}\nWe will withdraw the money from your bank account within the next days.\n{/if}\n{if $additional.payment.name == "prepayment"}\n \nOur bank connection:\nAccount: ###\nBIN: ###\n{/if}\n \n{if $sComment}\nYour comment:\n{$sComment}\n{/if}\n \nBilling address:\n{$billingaddress.company}\n{$billingaddress.firstname} {$billingaddress.lastname}\n{$billingaddress.street} {$billingaddress.streetnumber}\n{$billingaddress.zipcode} {$billingaddress.city}\n{$billingaddress.phone}\n{$additional.country.countryname}\n \nShipping address:\n{$shippingaddress.company}\n{$shippingaddress.firstname} {$shippingaddress.lastname}\n{$shippingaddress.street} {$shippingaddress.streetnumber}\n{$shippingaddress.zipcode} {$shippingaddress.city}\n{$additional.country.countryname}\n \n{if $billingaddress.ustid}\nYour VAT-ID: {$billingaddress.ustid}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n{/if}\n ";s:11:"contentHtml";s:3556:"<div style="font-family:arial; font-size:12px;">\n \n<p>Hello {$billingaddress.firstname} {$billingaddress.lastname},<br/><br/>\n \nThank you for your order with {config name=shopName} (Nummer: {$sOrderNumber}) on {$sOrderDay} at {$sOrderTime}.\n<br/>\n<br/>\n<strong>Information on your order:</strong></p>\n  <table width="80%" border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:10px;">\n    <tr>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art.No.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Pos.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Art-Nr.</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n      <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n \n    {foreach item=details key=position from=$sOrderDetails}\n    <tr>\n      <td rowspan="2" style="border-bottom:1px solid #cccccc;">{if $details.image.src.1}<img src="{$details.image.src.1}" alt="{$details.articlename}" />{else} {/if}</td>\n      <td>{$position+1|fill:4} </td>\n      <td>{$details.ordernumber|fill:20}</td>\n      <td>{$details.quantity|fill:6}</td>\n      <td>{$details.price|padding:8}{$sCurrency}</td>\n      <td>{$details.amount|padding:8} {$sCurrency}</td>\n    </tr>\n    <tr>\n      <td colspan="5" style="border-bottom:1px solid #cccccc;">{$details.articlename|wordwrap:80|indent:4}</td>\n    </tr>\n    {/foreach}\n \n  </table>\n \n<p>\n  <br/>\n  <br/>\n    Shipping costs:: {$sShippingCosts}<br/>\n    Total net: {$sAmountNet}<br/>\n    {if !$sNet}\n    Total gross: {$sAmount}<br/>\n    {/if}\n  <br/>\n  <br/>\n    <strong>Selected payment type:</strong> {$additional.payment.description}<br/>\n    {$additional.payment.additionaldescription}\n    {if $additional.payment.name == "debit"}\n    Your bank connection:<br/>\n    Account number: {$sPaymentTable.account}<br/>\n    BIN:{$sPaymentTable.bankcode}<br/>\n    We will withdraw the money from your bank account within the next days.<br/>\n    {/if}\n  <br/>\n  <br/>\n    {if $additional.payment.name == "prepayment"}\n    Our bank connection:<br/>\n    {config name=bankAccount}\n    {/if} \n  <br/>\n  <br/>\n    <strong>Selected dispatch:</strong> {$sDispatch.name}<br/>{$sDispatch.description}\n</p>\n<p>\n  {if $sComment}\n    <strong>Your comment:</strong><br/>\n    {$sComment}<br/>\n  {/if} \n  <br/>\n  <br/>\n    <strong>Billing address:</strong><br/>\n    {$billingaddress.company}<br/>\n    {$billingaddress.firstname} {$billingaddress.lastname}<br/>\n    {$billingaddress.street} {$billingaddress.streetnumber}<br/>\n    {$billingaddress.zipcode} {$billingaddress.city}<br/>\n    {$billingaddress.phone}<br/>\n    {$additional.country.countryname}<br/>\n  <br/>\n  <br/>\n    <strong>Shipping address:</strong><br/>\n    {$shippingaddress.company}<br/>\n    {$shippingaddress.firstname} {$shippingaddress.lastname}<br/>\n    {$shippingaddress.street} {$shippingaddress.streetnumber}<br/>\n    {$shippingaddress.zipcode} {$shippingaddress.city}<br/>\n    {$additional.countryShipping.countryname}<br/>\n  <br/>\n    {if $billingaddress.ustid}\n    Your VAT-ID: {$billingaddress.ustid}<br/>\n    In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax. \n    {/if}\n  <br/>\n  <br/>\n\n    Your Team of {config name=shopName}<br/>\n</p>\n</div>";}'
            AND objecttype = 'config_mails'
            AND objectkey = 2;
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        UPDATE s_cms_support_fields SET
            typ = 'text',
            label = 'Straße & Hausnummer',
            class = 'normal'
        WHERE
            typ = 'text2'
            AND name = 'strasse'
            AND class = 'strasse;nr'
            AND label = 'Straße ; Hausnummer';
EOD;
        $this->addSql($sql);

        $sql = <<<'EOD'
        UPDATE s_cms_support_fields SET
            typ = 'text',
            label = 'Street & house number',
            class = 'normal'
        WHERE
            typ = 'text2'
            AND name = 'strasse'
            AND class = 'strasse;nr'
            AND label = 'Street ; house number';
EOD;
        $this->addSql($sql);
    }
}
